@extends('include.dashboard')
@section('content')
    <!-- content @s -->
                <div class="nk-content nk-content-fluid">
                    <div class="container-xl wide-lg">
                        <div class="nk-content-body">
                            <div class="buysell wides-xs m-autso">
                                <div class="buysell-title text-center">
                                    <h4 class="title">{{$page_title}}</h4>
                                </div><!-- .buysell-title -->
                                <div class="buysell-block">
                                     <form action="{{ route('pin.recharge.post') }}"  class="buysell-form" method="POST">
                                    @csrf
                                        <div class="buysell-field form-group">
                                            <div class="form-label-group">
                                                <label class="form-label">Account Balance</label>
                                            </div>
                                            <input type="hidden" value="btc" name="bs-currency" id="buysell-choose-currency">
                                            <div class="dropdown buysell-cc-dropdown">
                                                <a href="#" class="buysell-cc-choosen">
                                                    <div class="coin-item coin-btc">
                                                        <div class="coin-icon">
                                                            <em class="icon ni ni-wallet-alt"></em>
                                                        </div>
                                                        <div class="coin-info">
                                                            <span class="coin-name">{{$basic->currency_sym}}{{number_format(Auth::user()->balance, $basic->decimal)}} </span>
                                                            <span class="coin-text">Current Balance</span>
                                                        </div>
                                                    </div>
                                                </a>

                                            </div><!-- .dropdown -->
                                        </div><!-- .buysell-field -->
                                        <div class="buysell-field form-group">
                                            <div class="form-label-group">
                                                <label class="form-label" for="buysell-amount">Enter Pin</label>
                                            </div>
                                            <div class="form-control-group">
                                                <input type="text" name="pin" class="form-control form-control-lg form-control-number" id="buysell-amount" name="bs-amount" placeholder="5262-XXX-XXX-XXX">

                                            </div>
                                            <div class="buysell-field form-action">
                                            <button type="submit" class="btn btn-lg btn-block btn-primary" data-toggle="modal" data-target="#buy-coin">Continue to Recharge</button>
                                        </div><!-- .buysell-field -->
                                        </form>




                                        </div><!-- .buysell-field -->

          <br><a href="#createEpinModal" card data-toggle="modal" class="btn btn-primary  float-right">@lang('Create New E-Pin')</a>
            <h5 style="padding-left:20px" class="card-header ">
                @lang('My created E-Pin')

            </h5>
            <div class="card">
                <div class="table-responsive table-responsive-xl ">
                    <table class="table align-items-center table-light ">
                        <thead>
                        <tr>
                            <th scope="col">@lang('Amount')</th>
                            <th scope="col">@lang('Pin')</th>
                            <th scope="col">@lang('Status')</th>
                        </tr>
                        </thead>


                        <tbody class="list">
                        @forelse($epin as $data)
                            <tr>
                                <td>{{$basic->currency_sym}}{{ $data->amount }}</td>
                                <td>{{ $data->pin }}</td>
                                <td>@if($data->status == 1) <span class="badge badge-success">@lang('Not Used')</span> @else <span class="badge badge-warning">@lang('Used')</span> @endif</td>
                            </tr>
                        @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{__('NO DATA FOUND')}}</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="card-footer py-4">
                    <nav aria-label="...">

                        {{$epin->links()}}
                    </nav>
                </div>
            </div>
            <br>

                                        <div class="form-note text-base text-center">Note: You can resell E-pin to other {{$basic->sitename}} users and earn more.</div>
                                        <div class="form-note text-base text-center">Upgrade  to <a href="/user/upgrade-downgrade"> {{$basic->sitename}} Certified Re-seller</a> and buy E-pin at lesser price.</div>
                                        

                                </div><!-- .buysell-block -->
                            </div><!-- .buysell -->
                        </div>
                    </div>
                </div>



                 <div class="modal fade" id="createEpinModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel"> @lang('Create New Pin')</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                </div>
                <form  method="post" action="{{route('pin.generate')}}">
                    @csrf
                    <div class="modal-body text-center">

                        <strong class="text-center">@lang('Amount')</strong>
                        <div class="input-group">
                            <input type="text" class="form-control input-lg" name="amount">
                            <div class="input-group-append">
                            <span class="input-group-text">
                                {{__($basic->currency_sym)}}
                            </span>
                            </div>

                        </div>
                        <small class="text-center text-danger">@lang('This amount will subtract from your wallet and generate new pin.')</small>
                    </div>
                    <div class="modal-footer">
                        <button type="submit"  class="btn btn-primary bold uppercase"><i class="fa fa-send"></i> @lang('Generate')</button>
                        <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-times"></i> @lang('Close')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>



                <!-- content @e -->@stop
